//This macros was written by Steve Rothery
//FILM - Facility for Imaging by Light Microscopy, Imperial College London
//http://www.imperial.ac.uk/medicine/facility-for-imaging-by-light-microscopy/software/fiji/
//for Dr Blerina Ahmetaj-Shala and Prof Jane Mitchell (NHLI, Imperial College London) 
//to investigate whether cells derived from smooth muscle progenitors can contract.


//initialise
requires("1.52t");
run("Set Measurements...", "area mean min perimeter feret's display redirect=None decimal=3");
roiManager("reset");
run("Clear Results");

//open image and get dimensions
open();
output=getDirectory("image");
fn=getTitle();


getDimensions(ImageWidth, ImageHeight, ImageChannels, ImageSlices, ImageFrames);
getVoxelSize(px, py, pz, unit);
Stack.getUnits(Xunit, Yunit, Zunit, Timeunit, LutValue);
frameInterval=floor(Stack.getFrameInterval());
run("Duplicate...", "title=temp duplicate channels=1");
selectWindow(fn);
close();


//align option
align=getBoolean("Align image");
if (align==true){
selectWindow("temp");
run("Descriptor-based series registration (2d/3d + t)", "series_of_images=[temp] brightness_of=Medium approximate_size=[10 px] type_of_detections=[Maxima only] subpixel_localization=[3-dimensional quadratic fit] transformation_model=[Rigid (2d)] images_are_roughly_aligned number_of_neighbors=3 redundancy=1 significance=3 allowed_error_for_ransac=5 global_optimization=[All-to-all matching with range ('reasonable' global optimization)] range=5 choose_registration_channel=1 image=[Fuse and display]");
setVoxelSize(px, py, pz, unit);
Stack.setUnits(Xunit, Yunit, Zunit, Timeunit, LutValue);
Stack.setFrameInterval(frameInterval);
selectWindow("temp");
close();
}

//create summary arrays
rename(fn);
mean_area_change=newArray(ImageFrames);
mean_length_change=newArray(ImageFrames);
mean_width_change=newArray(ImageFrames);


//draw rois
setTool("freehand");
run("Subtract Background...", "rolling=50 stack");// processing
run("Smooth", "stack");//processing
run("Enhance Contrast", "saturated=0.35");
waitForUser("","draw around cells and add to roi manager by pressing t \n then press ok");

//threshold
run("Threshold...");
setAutoThreshold("Huang dark");
waitForUser("","check Threshold \n then press ok");

//main loop
n=roiManager("count");
roiManager("Remove Frame Info");
for(roi=0;roi<n;roi++){
	firstRoi=roiManager("count");
	roiManager("select", roi);
	roiManager("rename", "Cell "+roi+1);
	run("Analyze Particles...", "size=1000.00-Infinity summarize add stack");

lastRoi=roiManager("count");

//name rois
for (newroi=firstRoi;newroi<lastRoi;newroi++){
roiManager("select", newroi);
Roi.getPosition(roichannel, roislice, roiframe)
roiManager("rename", "cell "+roi+1+" frame "+roislice);
}


//select data
selectWindow("Summary of "+fn);
IJ.renameResults("Summary of "+fn,"Results");

Cell_area=Table.getColumn("Total Area");
Cell_length=Table.getColumn("Feret");
Cell_width=Table.getColumn("MinFeret");
Area_change=newArray(ImageFrames);
length_change=newArray(ImageFrames);
width_change=newArray(ImageFrames);
frame=newArray(ImageFrames);

//analyse data
for (res=0;res<ImageFrames;res++){
Area_change[res]=Cell_area[res]/Cell_area[0]*100;
length_change[res]=Cell_length[res]/Cell_length[0]*100;
width_change[res]=Cell_width[res]/Cell_width[0]*100;	
frame[res]=frameInterval*res;
mean_area_change[res]=mean_area_change[res]+Area_change[res];
mean_length_change[res]=mean_length_change[res]+length_change[res];
mean_width_change[res]=mean_width_change[res]+width_change[res];
}

//print data
Table.create(fn+" Cell "+roi+1+" Results");
Table.setLocationAndSize(800, 200+roi*30, 850, 500);
Table.setColumn("Time ("+Timeunit+")",frame);
Table.setColumn("Cell Area",Cell_area);
Table.setColumn("% Change in Area",Area_change);
Table.setColumn("Cell Length (Feret)",Cell_length);
Table.setColumn("% Change in Length",length_change);
Table.setColumn("Cell Width (Min Feret)",Cell_width);
Table.setColumn("% Change in Width",width_change);
selectWindow("Results");
run("Close");

//save results file
selectWindow(fn+" Cell "+roi+1+" Results");
out = output + fn+" Cell "+roi+1+" Results.xls";
saveAs("Results",out);
run("Close");	
}

//calculate and display means
for (res=0;res<ImageFrames;res++){
mean_area_change[res]=mean_area_change[res]/n;
mean_length_change[res]=mean_length_change[res]/n;
mean_width_change[res]=mean_width_change[res]/n;
}
Table.create(fn+" Summary");
Table.setLocationAndSize(800, 200, 850, 300);
Table.setColumn("Time ("+Timeunit+")",frame);
Table.setColumn("Mean % change in Area",mean_area_change);
Table.setColumn("Mean % change in Length",mean_length_change);
Table.setColumn("Mean % change in width",mean_width_change);

//save results file
selectWindow(fn+" Summary");
run("Select None");
out = output + fn+" Summary.xls";
saveAs("Results",out);
run("Close");

//remove drawn rois
drawn=Array.getSequence(n);
roiManager("select", drawn);
roiManager("delete");

//save rois
roiout = output + fn + " ROIs.zip";
roiManager("Save", roiout);


//save drawing or image
selectWindow(fn);
out = output + fn + " with overlay";
saveAs("Tiff",out);
close();

//finish up
setTool("rectangle");